@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content">
		<div class="container-fluid pt-3">
			<div class="card border-0 shadow-custom">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('membership.title') }}
					</h3>
				</div>
				<form method="post" action="{{ route('membership.store') }}">
					{{ csrf_field() }}
					<div class="card-body">
						<div class="row">
							<div class="col-lg-12">
								<div class="form-group">
									<label for="member-form">{{ __('membership.member') }}</label>
									<select class="form-control select-member @error('member') is-invalid @enderror"
										name="member" id="member-form">
										@foreach($members as $member)
										<option value="{{ $member->id }}" {{ ($member->id == $id || $member->id ==
											old('member')) ? 'selected' : '' }} >
											{{ $member->name }}
										</option>
										@endforeach
									</select>
									@error('member')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="js-membership-type">{{ __('membership.membership') }}</label>
									<select
										class="form-control select-membership-type @error('type') is-invalid @enderror"
										name="type" id="js-membership-type">
										@foreach($types as $type)
										<option value="{{ $type->id }}" {{ old('type')==$type->id ? 'selected' : '' }}
											data-duration="{{ $type->duration }}">
											{{ $type->name }}
										</option>
										@endforeach
									</select>
								</div>
								@error('type')
								<span class="d-block invalid-feedback">{{ $message }}</span>
								@enderror
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-valid-from" class="required">{{ __('membership.valid_from')
										}}</label>
									<div class="input-group date" id="date-valid-from" data-target-input="nearest">
										<input type="text"
											class="form-control  @error('valid_from') is-invalid @enderror"
											value="{{ old('valid_from') }}" name="valid_from"
											data-target="#date-valid-from" id="js-valid-from" />
										<div class="input-group-append" data-target="#date-valid-from"
											data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fa fa-calendar"></i></div>
										</div>
									</div>
									@error('valid_from')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-valid-to" class="required">{{ __('membership.to') }}</label>
									<div class="input-group mb-3">
										<input type="text" class="form-control @error('valid_to') is-invalid @enderror"
											value="{{ old('valid_to') }}" name="valid_to" id="js-valid-to" readonly>
										<div class="input-group-append">
											<span class="input-group-text"><i class="fa fa-calendar"></i></span>
										</div>
									</div>
									@error('valid_to')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<button type="submit" class="btn btn-primary mt-1">{{ __('membership.save_membership')
									}}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection
@section('js-script')
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE SELECT2 ELEMENT
		$('.select-member, .select-membership-type').select2({
			theme: 'bootstrap4'
		})

		// INITIALIZE THE DATE PICKER
		$('#date-valid-from').datetimepicker({
			format: 'YYYY-MM-DD'
		});

		// CALCULATE THE MEMBERSHIP VALID TO DATE
		$('#js-membership-type, #js-valid-from').on('change input', function () {
			var membershipId = parseInt($('#js-membership-type option:selected').val());
			var membershipDuration = parseInt($('#js-membership-type option:selected').data('duration'));
			var validFromDate = moment($('#js-valid-from').val(), 'YYYY-MM-DD');

			if (validFromDate.isValid() && !isNaN(membershipDuration)) {
				var validToDate = validFromDate.clone().add(membershipDuration, 'days');
				$('#js-valid-to').val(validToDate.format('YYYY-MM-DD'));
			}
		});
	});
</script>
@endsection